//-----------------------------------------------------------------------------
// seekbyframe.m
//
// Example of an Animated Seekbar using Frames
// (Improved, no longer requires HiddenSeek)
//
// written by FrisbeeMonkey
// bug caught and fixed by iPlayTheSpoons
//-----------------------------------------------------------------------------

//                            USING THIS SCRIPT:
//*****************************************************************************
//  1.  Define the following in your XML:
//        <AnimatedLayer
//          id="SeekAnim"
//          x="?" y="?"
//          w="?" h="?"
//          image="player.anim.seek"
//          move="0"
//          autoplay="0"
//          autoreplay="0"
//        />
//
//      Change the position(x,y) and size(w,h) of "SeekAnim" to the specifics
//      of your layer. (NOTE: w and h refer to just one frame, not the whole image)
//  2.  Define your gradient map with your other elements using:
//        <bitmap id="player.map.seek" file="player/player-map-seek.png"/>
//      If you need help creating a map file, check:
//        http://www.stefanweb.com/wa3/tutorials.html#UsingMaps
//  3.  Make sure your ticker is called "SongTicker" and is in the same group as
//      "SeekAnim".  If you don't have a ticker, add one now.
//  4.  Copy this script (and seekbyframe.maki) to your scripts folder.
//  5.  If you don't have seekbyframe.maki, compile this script.
//  6.  Add this line to the group that contains your layer and SongTicker
//        <script id="seek" file="scripts/seekbyframe.maki"/>
//  7.  Refresh your skin(F5) and try it out.
//*****************************************************************************

// Never forget to include std.mi
#include </lib/std.mi>

// Declare local functions for use in script
Function setSeekAnim(int posValue);
Function updateSeek(int x, int y);

// Declare global variables for use in script
Global AnimatedLayer Seek;
Global Map SeekMap;
Global Text SongTicker;
Global Timer SongTickerTimer, SongPlayingTimer;
Global Boolean SeekChanging;

// When the script/skin is loaded, do this
System.onScriptLoaded() {
	Group ScriptGrp = getScriptGroup();

	// Get Seek Layer and SongTicker
	Seek = ScriptGrp.findObject("SeekAnim");
	SongTicker = ScriptGrp.findObject("SongTicker");

	// Initialize our timers
	SongTickerTimer = new Timer;
	SongTickerTimer.setDelay(750);
	SongPlayingTimer = new Timer;
	SongPlayingTimer.setDelay(1000);

	// Initialize Maps
	SeekMap = new Map;
	SeekMap.loadMap("player.map.seek");

	// Start SongPlayingTimer if Media is Playing
	if (getplayitemstring() != "") {
		SongPlayingTimer.start();
		setSeekAnim(255 * System.getPosition() / System.getPlayItemLength());
	} else {
		setSeekAnim(0);
	}
}

// When Media is Played, Start Updates.
System.onPlay() {
	SongPlayingTimer.start();
}

// When Media is Stopped, Discontinue Updates, Set Seek to 0.
System.onStop() {
	SongPlayingTimer.stop();
	setSeekAnim(0);
}

// Updates Seek as Media Advances
SongPlayingTimer.onTimer() {
	setSeekAnim(255 * System.getPosition() / System.getPlayItemLength());
}

// Clears Text Area
SongTickerTimer.onTimer() {
	SongTicker.setText("");
	SongTickertimer.stop();
}

// Sets the Animation to Correct Region
setSeekAnim(int Value) {
	int f = (Value * (Seek.getLength()-1)) / 255;
    if (Value > 0) {
	Seek.gotoFrame(f+1);
	}
    if (Value == 255) {
	Seek.gotoFrame(f);
    }
    if (Value == 0) {
	Seek.gotoFrame(0);
    }
}

// Starting to Seek
Seek.onLeftButtonDown(int x, int y) {
	SongPlayingTimer.stop();
	SeekChanging = 1;
	updateSeek(x, y);
}
// Stop Seeking
Seek.onLeftButtonUp(int x, int y) {
	SongPlayingTimer.start();
	if (SeekChanging) {
		SeekChanging = 0;
		updateSeek(x, y);
	}
}
// Seeking
Seek.onMouseMove(int x, int y) {
	if (SeekChanging) {
		updateSeek(x, y);
	}
}


// Updates Seek Image and System Position
updateSeek(int x, int y) {
	int newValue = SeekMap.getValue(x - Seek.getLeft(), y - Seek.getTop());
	if (System.getPlayItemLength() >= 0) {
		int p = (newValue * 100) / 255;
		int s = (newValue * System.getPlayItemLength()) / 255;
		Songtickertimer.stop();
		Songtickertimer.start();
		Songticker.setAlternateText(System.integerToTime(s) + "/" + System.integerToTime(System.getPlayItemLength()) + " (" + System.integerToString(p) + "%)");
		if (!SeekChanging) {
			System.seekTo(s);
		}
		setSeekAnim(255 * s / System.getPlayItemLength());
	}
}

// When Script/Skin Unloads, Delete Maps.
System.onScriptUnloading() {
	delete SongPlayingTimer;
	delete SongTickerTimer;
	delete SeekMap;
}